from collections import namedtuple

from .. import core

AliasInfo = namedtuple('AliasInfo', ('id', 'name', 'site_id'))


class AliasOperator(object):
    FilterAll = core.FilterAll
    FilterBySiteName = core.declare_filter('FilterBySiteName', 'site-name')
    FilterByName = core.declare_filter('FilterByName', 'name')

    class Get(core.operation_with_filter('Get')):
        operator_name = 'site-alias'
        operation_name = 'get'
        min_api_version = '1.6.3.0'
        max_api_version = None

        @classmethod
        def parse(cls, elem):
            return core.parse_result_set(elem, cls._parse_data, 'id')

        @classmethod
        def _parse_data(cls, elem):
            id = int(elem.findtext('id'))
            site_id = int(elem.findtext('info/site-id'))
            name = elem.findtext('info/name')

            return id, AliasInfo(id=id, name=name, site_id=site_id)