from parallels.plesk.source.web import messages
import posixpath

from parallels.core.actions.base.subscription_action import SubscriptionAction


class FixPermissions(SubscriptionAction):
    def get_description(self):
        return messages.ACTION_FIX_PERMISSIONS

    def get_failure_message(self, global_context, subscription):
        return messages.ACTION_FIX_PERMISSIONS_FAILED.format(subscription=subscription.name)

    def filter_subscription(self, global_context, subscription):
        # skip this action for subscriptions w/o web and for windows subscriptions
        if subscription.web_target_server is None or subscription.web_target_server.is_windows():
            return False
        return True

    def is_critical(self):
        """If action is critical or not

        If action is critical and it failed for a subscription, migration tool
        won't run the next operations for the subscription.

        :rtype: bool
        """
        return False

    def run(self, global_context, subscription):
        """Set file owner and permissions for transferred subscription content.

        Plesk vhost permissions are described in 'Parallels Plesk Panel 12.0
        Advanced Administration Guide':
        http://download1.parallels.com/Plesk/PP12/12.0/Doc/en-US/online/plesk-linux-advanced-administration-guide/68806.htm
        """
        target_server = subscription.web_target_server

        target_vhost_dir = target_server.join_file_path(target_server.vhosts_dir, subscription.name.encode('idna'))
        sysuser_name = subscription.converted_dump.get_phosting_sysuser_name()
        find_options = {
            'find_path': target_vhost_dir,
            'owner': sysuser_name,
            'group': 'psacln',
        }
        chmod_commands = [
            dict(find_type='f', find_perm='a+r'),
            dict(find_type='d', find_perm='a+rx'),
        ]

        with target_server.runner() as runner_target:
            for find_chmod_options in chmod_commands:
                runner_target.sh(
                    u"/usr/bin/find {find_path} \
                        -type {find_type} \
                        -not -group psaserv \
                        -exec chown {owner}:{group} {{}} \; \
                        -exec chmod {find_perm} {{}} \;",
                    dict(find_options, **find_chmod_options)
                )

            target_vhost_log_dir = target_server.join_file_path(
                target_server.vhosts_dir,
                'system', subscription.name.encode('idna'), 'logs'
            )
            runner_target.sh(u"chown psaadm:psacln {log_dir}", dict(log_dir=target_vhost_log_dir))

            runner_target.sh(
                u"chown :psaserv {httpdocs_dir}", dict(httpdocs_dir=posixpath.join(target_vhost_dir, 'httpdocs'))
            )
