from parallels.core.workflow.extension import WorkflowExtensionBase
from parallels.core.actions.content.web.copy_unix_content_base import CopyUnixWebContent
from parallels.core.actions.base.legacy_action import LegacyAction
from parallels.plesk.source.ppcpl import messages
from parallels.plesk.source.ppcpl.actions.content.web.fix_permissions import FixPermissions


class WorkflowExtension(WorkflowExtensionBase):
    def extend_workflow(self, workflow):
        """Extend shared hosting workflow with source-panel specific actions

        :type workflow: parallels.core.workflow.base_workflow.BaseWorkflow
        """
        for fetch_action in ('fetch-source', 'fetch-source-shallow'):
            workflow.get_shared_action(fetch_action).insert_action(
                'fetch-data', LegacyAction(
                    description=messages.ACTION_FETCH_SOURCE_DATA,
                    function=lambda ctx: ctx.migrator._fetch_source(
                        ctx.options, ctx.options.reload_source_data
                    )
                )
            )

        workflow.get_shared_action('copy-web-files').insert_action(
            'copy-files', CopyUnixWebContent()
        )
        workflow.get_shared_action('sync-web-content-assets').insert_action(
            'fix-permissions', FixPermissions()
        )
        workflow.get_path('check/check-data').insert_action(
            'check-additional', LegacyAction(
                description=messages.ACTION_CHECK_ADDITIONAL,
                function=lambda ctx: ctx.migrator._check_additional(ctx.pre_check_report)
            )
        )
