from parallels.core.utils.common import cached, group_value_by
from parallels.plesk.source.plesk.shallow_dump.model.base.client import Client
from parallels.plesk.source.plesk.shallow_dump.model.base.domain import Domain
from parallels.plesk.source.plesk.shallow_dump.model.base.reseller import Reseller
from parallels.plesk.source.plesk.shallow_dump.model.base.template import Template
from parallels.plesk.source.plesk.shallow_dump.model.plesk_base import PleskShallowDumpModel


class Plesk10ShallowDumpModel(PleskShallowDumpModel):
    """Shallow dump object for source Plesk >= 10 panel"""
    @property
    @cached
    def clients(self):
        query_results = self._dump_agent.execute_sql(
            "SELECT id, vendor_id, login, pname FROM clients WHERE type = 'client'"
        )
        return [
            Client(
                client_id=data['id'], login=data['login'], contact_name=data['pname'],
                owner_id=data['vendor_id']
            )
            for data in query_results
        ]

    @property
    @cached
    def resellers(self):
        query_results = self._dump_agent.execute_sql("""
            SELECT Subscriptions.id as subscription_id, clients.id, login, pname
                FROM clients
                LEFT JOIN Subscriptions ON
                    Subscriptions.object_id = clients.id
                    AND Subscriptions.object_type = 'client'
                WHERE clients.type = 'reseller'
        """)
        return [
            Reseller(
                reseller_id=data['id'], login=data['login'], contact_name=data['pname'],
                subscription_id=data['subscription_id']
            )
            for data in query_results
        ]

    @property
    @cached
    def domains(self):
        query_results = self._dump_agent.execute_sql("""
            SELECT Subscriptions.id as subscription_id, displayName as name, cl_id
              FROM domains
              LEFT JOIN Subscriptions ON
                domains.id = Subscriptions.object_id AND Subscriptions.object_type = 'domain'
              WHERE webspace_id = 0
        """)
        return [
            Domain(name=data['name'], owner_id=data['cl_id'], subscription_id=data['subscription_id'])
            for data in query_results
        ]

    @property
    @cached
    def templates(self):
        query_results = self._dump_agent.execute_sql("SELECT id, owner_id, name, type, uuid FROM Templates")
        return [
            Template(
                template_id=data['id'], name=data['name'], template_type=data['type'],
                guid=data['uuid'], owner_id=data['owner_id']
            )
            for data in query_results
        ]

    @property
    @cached
    def subscription_id_to_plan_ids(self):
        return group_value_by(self._plan_subscriptions, lambda ps: ps['subscription_id'], lambda ps: ps['plan_id'])

    @property
    @cached
    def admin_ids(self):
        query_results = self._dump_agent.execute_sql("""
            SELECT id FROM clients WHERE type = 'admin'
        """)
        return {data['id'] for data in query_results}

    @property
    @cached
    def _plan_subscriptions(self):
        return self._dump_agent.execute_sql("SELECT subscription_id, plan_id FROM PlansSubscriptions")