from parallels.core.utils.entity import Entity


class Domain(Entity):
    """Shallow information about domain

    By domain here we mean webspace or subscription in terms of recent Plesk versions,
    but not addon domains, subdomains or aliases
    """

    def __init__(self, name, owner_id, subscription_id=None):
        self._name = name
        self._owner_id = owner_id
        self._subscription_id = subscription_id

    @property
    def name(self):
        """Domain's name

        :rtype: str | unicode
        """
        return self._name

    @property
    def owner_id(self):
        """Owner ID of domain - client's ID, reseller's ID or administrator

        :rtype: str | unicode
        """
        return self._owner_id

    @property
    def subscription_id(self):
        """Subscription ID to which domain is assigned to

        If subscription is custom (not assigned to any plan), this property is None

        :rtype: str | unicode | None
        """
        return self._subscription_id
