from parallels.plesk.source.plesk.hosting_description.plesk_entity_factory import PleskEntityFactory
from parallels.plesk.source.plesk.hosting_description.plesk_entity_factory_125 import PleskEntityFactory125


def create_plesk_entity_factory(selection, dump_agent):
    """
    :type selection: parallels.core.utils.pmm.agent.DumpAll|parallels.core.utils.pmm.agent.DumpSelected
    :type dump_agent: parallels.core.utils.pmm.agent.PmmMigrationAgentBase
    :rtype: parallels.plesk.source.plesk.hosting_description.plesk_entity_factory.PleskEntityFactory
    """
    if dump_agent.source_server().plesk_version >= (12, 5):
        return PleskEntityFactory125(selection, dump_agent)
    else:
        return PleskEntityFactory(selection, dump_agent)
