import logging

from parallels.core.actions.base.common_action import CommonAction
from parallels.plesk.source.helm3 import messages

logger = logging.getLogger(__name__)


class FetchShallowDumpAction(CommonAction):
    def get_description(self):
        return messages.ACTION_FETCH_SHALLOW_DUMP_DESCRIPTION

    def get_failure_message(self, global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        return messages.ACTION_FETCH_SHALLOW_DUMP_FAILURE

    def run(self, global_context):
        """
        :type global_context: parallels.plesk.source.helm3.global_context.Helm3GlobalMigrationContext
        """
        shallow_backup_filename = global_context.session_files.get_path_to_shallow_plesk_backup('helm3')
        global_context.helm3_agent.create_shallow_dump(shallow_backup_filename)