#!/usr/bin/perl
# Copyright 1999-2016. Parallels IP Holdings GmbH. All Rights Reserved.
#
# Determine and print

use lib '.';

use CompatArgParse;
use Dumper;

sub printHelp {
	print <<'HELP';

Usage:
  $0 <command>

Commands:
  -s |--sysuser     get vhost dir of given sysuser status
  -h |--help        this help

HELP
}

my %arg_opts = (
    '--help|-h'	=> '',
    '--sysuser|-s'	=> '',
  );

my $args = CompatArgParse::parse( \@ARGV, \%arg_opts );

if ( exists $args->{'sysuser'} ) {
	my $home_dir = Dumper::getHomeDir($ARGV[0]);
	print $home_dir . "\n";
	exit(0)
} elsif (exists $args->{'help'}) {
	printHelp();
	exit(0)
}

exit(1);