from parallels.plesk.hosting_repository.utils.cli.base import BaseCli


class IpPoolAddCli(BaseCli):
    def __init__(self, runner, ip_address, ip_type, owner_username):
        super(IpPoolAddCli, self).__init__(runner)
        self._ip_address = ip_address
        self._ip_type = ip_type
        self._owner_username = owner_username

    @property
    def name(self):
        return 'ip_pool'

    def _get_args(self):
        return [
            '--add', self._ip_address,
            '-type', self._ip_type,
            '-owner', self._owner_username
        ]
