from parallels.plesk.hosting_repository.utils.cli.base import BaseCli


class BackupRestoreHelperGetExtensionHooksCli(BaseCli):
    @property
    def name(self):
        return 'backup_restore_helper'

    @property
    def is_private(self):
        return True

    def _get_args(self):
        return [
            '--get-extensions-hooks'
        ]


class BackupRestoreHelperBackupExtensionCli(BaseCli):
    def __init__(self, runner, extension_id, backup_type, entity_id=None):
        super(BackupRestoreHelperBackupExtensionCli, self).__init__(runner)
        self._extension_id = extension_id
        self._backup_type = backup_type
        self._entity_id = entity_id

    @property
    def name(self):
        return 'backup_restore_helper'

    @property
    def is_private(self):
        return True

    def _get_args(self):
        args = [
            '--backup-extension', self._extension_id,
            '-object-type', self._backup_type
        ]
        if self._entity_id is not None:
            args.extend(['-object-id', self._entity_id])
        return args


class BackupRestoreHelperPostBackupExtensionCli(BaseCli):
    def __init__(self, runner, extension_id, backup_type, entity_id=None):
        super(BackupRestoreHelperPostBackupExtensionCli, self).__init__(runner)
        self._extension_id = extension_id
        self._backup_type = backup_type
        self._entity_id = entity_id

    @property
    def name(self):
        return 'backup_restore_helper'

    @property
    def is_private(self):
        return True

    def _get_args(self):
        args = [
            '--post-backup-extension', self._extension_id,
            '-object-type', self._backup_type
        ]
        if self._entity_id is not None:
            args.extend(['-object-id', self._entity_id])
        return args


class BackupRestoreHelperRestoreExtensionCli(BaseCli):
    def __init__(self, runner, request):
        super(BackupRestoreHelperRestoreExtensionCli, self).__init__(runner)
        self._request = request

    @property
    def name(self):
        return 'backup_restore_helper'

    @property
    def is_private(self):
        return True

    def _get_args(self):
        return [
            '--restore-extension'
        ]

    def _get_stdin_content(self):
        return self._request
