from parallels.core.utils.common import is_string
from parallels.plesk.hosting_description.validate.validators.base import ValidatorBase
from parallels.plesk import messages


class ValidatorString(ValidatorBase):
    """Check that specified document is a string"""

    def validate(self, document, context=None):
        """Validate specified document (variable) according to current validator's rules

        Return list of found issues.

        :rtype: list[unicode]
        """
        if not self.match_type(document):
            return [self._format_error(messages.VALIDATOR_EXPECTED_STRING, context)]
        else:
            return []

    def match_type(self, document):
        """Check whether data type of document matched the validator

        That is necessary condition for "validate" method not to return errors

        :rtype: bool
        """
        return is_string(document)

    def __repr__(self):
        return 'ValidatorString()'

    def __eq__(self, other):
        return isinstance(other, ValidatorString)
