from parallels.plesk.hosting_description.validate.validators.base import ValidatorBase
from parallels.plesk import messages


class ValidatorBool(ValidatorBase):
    """Check that specified document is a boolean value"""

    TRUE_VALUES = (1, True, '1', 'on', 'true', 'enabled')
    FALSE_VALUES = (0, False, '0', 'off', 'false', 'disabled')

    def validate(self, document, context=None):
        """Validate specified document (variable) according to current validator's rules

        Return list of found issues.

        :rtype: list[unicode]
        """
        if not self.match_type(document):
            return [self._format_error(messages.VALIDATOR_EXPECTED_BOOLEAN_VALUE, context)]
        else:
            return []

    def match_type(self, document):
        """Check whether data type of document matched the validator

        That is necessary condition for "validate" method not to return errors

        :rtype: bool
        """
        return document in self.TRUE_VALUES or document in self.FALSE_VALUES

    def __repr__(self):
        return 'ValidatorBool()'

    def __eq__(self, other):
        return isinstance(other, ValidatorBool)
