from parallels.core.panels import load_target_panel_class, load_source_panel_class
from parallels.core.workflow.base_workflow import BaseWorkflow
from parallels.core.workflow.shared_hosting_workflow import SharedHostingWorkflowExtension


def create_workflow(context):
    """
    Create and return wrokflow object according given context
    :type context: parallels.core.global_context.GlobalMigrationContext
    :rtype: parallels.core.workflow.base_workflow.BaseWorkflow
    """
    workflow = BaseWorkflow()
    shared_hosting_extension = SharedHostingWorkflowExtension()
    shared_hosting_extension.extend_workflow(workflow)

    if context.target_panel_type is not None:
        # extend workflow with target-panel specific actions
        target_panel_workflow_class = load_target_panel_class(
            context.target_panel_type, 'workflow', 'WorkflowExtension'
        )
        target_workflow_extension = target_panel_workflow_class()
        target_workflow_extension.extend_workflow(workflow)

    if context.source_panel_type is not None:
        # extend workflow with source-panel specific actions
        source_workflow_extension_class = load_source_panel_class(
            context.target_panel_type, context.source_panel_type, 'workflow', 'WorkflowExtension'
        )
        source_workflow_extension = source_workflow_extension_class()
        source_workflow_extension.extend_workflow(workflow)

    return workflow