# Administrator's ID for internal data models of migrator
ADMIN_ID = 1

# username of Plesk administrator
ADMIN_USERNAME = 'admin'

# Type of Panel Migrator installation via own installer as standalone product
INSTALLATION_TYPE_STANDALONE = 'STANDALONE'

# Name of lock which block execution of any migration command except getting progress
LOCK_MIGRATION = 'migration'

# Name of lock which block execution of multiple instances of "run-queue" command within the same session
LOCK_RUN_QUEUE = 'run-queue'

# Name of lock which blocks operations with the queue: take task, add task, remove task
LOCK_QUEUE = 'queue'

# Name of lock which blocks operations with subscriptions status file
LOCK_SUBSCRIPTIONS_STATUS = 'subscriptions-status'

# Name of lock which blocks operations with subscriptions report file
LOCK_SUBSCRIPTIONS_REPORT = 'subscriptions-report'

IP_EXCLUSIVE = 'exclusive'
IP_SHARED = 'shared'

# Indicator meaning that we have no information about source database server
# so we should not try to copy database content for that database
DATABASE_NO_SOURCE_HOST = 'NO_SOURCE_HOST'

PLESK_PANEL_DEFAULT_PROTOCOL = 'https'
PLESK_PANEL_DEFAULT_PORT = 8443
SSH_DEFAULT_PORT = 22

PLESK_SECRET_KEY_DESCRIPTION = 'For Plesk Migrator extension'

# Default path to migrator's session directory on source Windows server.
# Keep it short to avoid issues with long paths.
WINDOWS_SOURCE_DEFAULT_SESSION_DIR = r'C:\migrator'

# Default path to migrator's session directory on source Unix server.
UNIX_SOURCE_DEFAULT_SESSION_DIR = '/tmp/panel_migrator'

FTP_SOURCE_DEFAULT_SESSION_DIR = 'panel_migrator'

# Default path to migrator's session directory on remote target Windows server.
# By remote we mean that server where migrator is running and target Windows server are different servers.
# Keep it short to avoid issues with long paths.
WINDOWS_REMOTE_TARGET_DEFAULT_SESSION_DIR = r'C:\migrator'

CACHE_OWNER_EXTENSION_DEPLOYER = 'deploy-extension-{extension_name}-{extension_data_type}-{entity_name}'

PLESK_EXTENSION_BACKUP_TYPE_SERVER = 'server'
PLESK_EXTENSION_BACKUP_TYPE_RESELLER = 'reseller'
PLESK_EXTENSION_BACKUP_TYPE_CUSTOMER = 'customer'
PLESK_EXTENSION_BACKUP_TYPE_SUBSCRIPTION = 'subscription'
PLESK_EXTENSION_BACKUP_TYPE_SITE = 'site'
PLESK_EXTENSION_HOOK_SERVER = 'server'
PLESK_EXTENSION_HOOK_RESELLER = 'reseller'
PLESK_EXTENSION_HOOK_CUSTOMER = 'customer'
PLESK_EXTENSION_HOOK_SUBSCRIPTION = 'subscription'
PLESK_EXTENSION_HOOK_SITE = 'site'
PLESK_EXTENSION_HOOK_SERVER_POST_BACKUP = 'server-post-backup'
PLESK_EXTENSION_HOOK_RESELLER_POST_BACKUP = 'reseller-post-backup'
PLESK_EXTENSION_HOOK_CUSTOMER_POST_BACKUP = 'customer-post-backup'
PLESK_EXTENSION_HOOK_SUBSCRIPTION_POST_BACKUP = 'subscription-post-backup'
PLESK_EXTENSION_HOOK_SITE_POST_BACKUP = 'site-post-backup'