
class BackupAdapterBase(object):
    def get(self, subscription):
        """
        :type subscription: parallels.core.migrated_subscription.MigratedSubscription
        """
        raise NotImplementedError()

    def get_backup_ids(self, global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        raise NotImplementedError()


class HostingPanelBackupIds(object):
    @staticmethod
    def get_backup_ids(global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        return [info.id for info in global_context.get_sources_info()]


class SubscriptionBackup(HostingPanelBackupIds, BackupAdapterBase):
    def get(self, subscription):
        """
        :type subscription: parallels.core.migrated_subscription.MigratedSubscription
        """
        return subscription.converted_dump


class SubscriptionBackupRaw(HostingPanelBackupIds, BackupAdapterBase):
    def get(self, subscription):
        """
        :type subscription: parallels.core.migrated_subscription.MigratedSubscription
        """
        return subscription.raw_dump
