class SubscriptionIPMapping(object):
    AUTO = 'auto'  # map to the same IP type as on source panel
    SHARED = 'shared'  # map to default shared IP address
    DEDICATED = 'dedicated'  # map to free dedicated IP address
    NONE = 'none'  # do not use IP of that type

    def __init__(self, v4=None, v6=None):
        if v4 is not None:
            self._v4 = v4
        else:
            self._v4 = SubscriptionIPMapping.AUTO
        if v6 is not None:
            self._v6 = v6
        else:
            self._v6 = SubscriptionIPMapping.AUTO

    @property
    def v4(self):
        return self._v4

    @property
    def v6(self):
        return self._v6

    @classmethod
    def possible_ip_mapping_values(cls):
        return {cls.AUTO, cls.SHARED, cls.DEDICATED, cls.NONE}

    def __eq__(self, other):
        return self.v4 == other.v4 and self.v6 == other.v6
