# coding=utf-8
"""
Messages overrides: messages specific to GUI
"""

from parallels.core.utils.message_utils import single_line_message, multi_line_message

UNABLE_LOGIN_S_SSH_SERVICE_DUE = multi_line_message("""
    Unable to login to %s by SSH service: administrator login and/or password are not correct.
    Set valid SSH credentials for the server and click "Prepare migration".
""")
WINDOWS_AGENT_INSTALL_INSTRUCTIONS = multi_line_message("""
    Panel Migrator failed to start RPC Agent on '{source_ip}' server.
    RPC Agent is required for communication between current server and '{source_ip}' server

    First, check that Windows Administrator's credentials specified for the server are correct.

    If they are correct, it is very likely that File and Printer Sharing service is disabled on the remote server,
    so automatic start of agent is not possible.

    Try to upload RPC Agent installation package to the {source_ip} server and run it manually.
""")
WINDOWS_AGENT_INSTALL_INSTRUCTIONS_VERSION_MISMATCH = multi_line_message("""
    RPC agent installed on '{source_ip}' server has version incompatible with Plesk Migrator.
    Panel Migrator tried to deploy new version of RPC agent, but failed to start it.

    RPC Agent is required for communication between current server and '{source_ip}' server

    First, check that Windows Administrator's credentials specified for the server are correct.

    If they are correct, it is very likely that File and Printer Sharing service is disabled on the remote server,
    so automatic start of agent is not possible.

    Try to upload RPC Agent installation package to the {source_ip} server and run it manually.
""")
WINDOWS_AGENT_CONNECTION_ISSUE = multi_line_message(r"""
    Panel Migrator failed to connect to RPC Agent running on '{source_ip}' server.
    RPC Agent is required for communication between current server and '{source_ip}' server

    1. Check that there are no firewall rules blocking connections to {port} port on {source_ip} from that server.
    Make sure you could connect to the source server by {port} port with "telnet" utility running on that server.
    2. Check that agent is running on the source server (panel-migrator-rpc-agent.exe process)
    and listening on {port} port. If it does not, try to start 'panel-migrator-rpc-agent.exe',
    which is usually installed to "%SYSTEMDRIVE%\panel-migrator\rpc-agent\". If it is still not running -
    investigate debug.log and info.log files on {source_ip} server
    (which are usually located at"%SYSTEMDRIVE%\panel-migrator\rpc-agent\ directory).
    3. Try to upload RPC Agent installation package to the {source_ip} server and run it manually.
""")
WINDOWS_AGENT_VERSION_MISMATCH = multi_line_message(r"""
    RPC Agent running on '{source_ip}' server has version that is not compatible
    with the current version of Plesk Migrator.
    RPC Agent is required for communication between current server and '{source_ip}' server.

    Stop previous version of RPC agent, upload RPC Agent installation package
    to the {source_ip} server and run it there.
""")
ACTION_READ_IP_MAPPING_IP_MAPPING_FILE_NOT_EXIST = single_line_message("""
    Internal error: IP-mapping file {ip_mapping_file} does not exist.
""")
FAILED_MIGRATE_CLIENT_SUBSCRIPTION = multi_line_message("""
    Subscription was not migrated: Failed to migrate customer that owns this subscription.
    Resolve issues with the customer (or create it manually) and restart migration.
""")
REVIEW_PRE_MIGRATION_ERRORS = single_line_message("""
    Review pre-migration issues and fix the errors before running migration.
""")
SKIP_COPY_DATABASE_DUE_TO_CONFLICT = single_line_message("""
    Skip copy database '{db_name}' from {db_type} server as there is some conflict.
""")
MIGRATION_LIST_NON_UNICODE_CHARS = single_line_message("""
    Internal error: There are non-UTF-8 characters in the migration list.
""")
# Empty message: we have no way to run post-migration checks from GUI separately from migration
RUN_TEST_ALL_AFTER_MIGRATION = ""
THERE_ARE_INFRASTRUCTURE_ISSUES_THAT_SHOULD = single_line_message("""
    There are infrastructure issues that should be fixed prior to the next migration steps.
""")
NOT_ENOUGH_DISK_SPACE = single_line_message("""
    %s has insufficient free disk space for migration. Free some disk space before running migration.
""")
FAILED_TO_CHECK_SERVICES = single_line_message("""
    Failed to check services: %s. Migration will proceed to the next steps.
""")
ERRORS_READING_MIGRATION_LIST = multi_line_message("""
    Internal error: There were some error(s) while reading migration list file:
    {errors}
""")
RESOLVE_ISSUE_DATABASE_CREATION_CREATE_DATABASE = single_line_message("""
    Resolve the issue with database creation or create database on target panel. Then run migration for the
    failed subscription once more.
""")
CRITICAL_INFRASTRUCTURE_ISSUES = multi_line_message("""
    There are infrastructure issues that should be fixed prior to the next migration steps.
""")
INFRASTRUCTURE_CHECK_INTERNAL_ERROR = single_line_message("""
    Failed to perform infrastructure checks: %s. Migration will proceed to the next steps.
""")
REVIEW_PRE_MIGRATION_ISSUES = single_line_message("""
    Review pre-migration tree above and fix the errors.
""")
# We can't edit service plan assignment from GUI, so this message is empty
FIX_SERVICE_TEMPLATE_SUBSCRIPTION_IS_ASSIGNED = ""
FAILED_TO_CHECK_DISK_SPACE_REQUIREMENTS = single_line_message("""
    Failed to check disk space requirements for %s: %s. Migration will proceed to the next steps.
""")
SSH_KEY_FILE_DOES_NOT_EXIST = multi_line_message("""
    Specified SSH key file does not exist. Please specify valid filename for private SSH key and restart migration.
""")
WINDOWS_PASSWORD_IS_NOT_SPECIFIED = multi_line_message("""
    Windows password is not specified for server '%s'.
""")
INVALID_EXTERNAL_DNS_SERVERS_OPTION = single_line_message("""
    Invalid external DNS server was specified. Specify valid IPv4 address in order for all DNS checks to be performed.
""")
RSYNC_FAILED_COPY_MAIL_CONTENT = multi_line_message("""
    Rsync failed to copy mail content from the source (%s) to the target server (%s): %s
    1. This could happen because of a network connection issue. Run migration for that subscription once more.
    2. Check whether rsync is installed and configured on the source server.
""")
FIX_DOMAINS_CONFLICT = single_line_message("""
    Change the conflicting names before migrating.
""")
FIX_SUBSCRIPTION_NAME_CONFLICT = single_line_message("""
    Rename one of the subscriptions (if you want to transfer both of them) or do not migrate one of them.
""")
SITE_CONFLICT_SOLUTION = single_line_message("""
    Either rename this subscription or the %s '%s' or do not migrate this subscription.
""")
SITE_CONFLICT_TARGET_SOLUTION = single_line_message("""
    Either rename this subscription or the %s '%s' or do not migrate this subscription.
""")
RSYNC_FAILED_COPY_DATABASE_DUMP = multi_line_message("""
    Rsync failed to copy a database dump from the source (%s) to the target server (%s): %s
    1. This could happen because of a network connection issue. Run migration for that subscription once more.
    2. Check whether rsync is installed on the source server.
""")
PG_DUMP_UTILITY_IS_NOT_INSTALLED = multi_line_message("""
    'pg_dump' utility is not installed on '%s' server. Install it so PostgreSQL databases could be migrated.
""")
FAILED_TO_PERFORM_OPEARATION_ON_IIS_APP_POOL = single_line_message("""
    Failed to %s IIS dedicated application pool.
""")
MIGRATION_LIST_FILE_NOT_EXIST = single_line_message("""
    Internal error: Migration list file '%s' does not exist.
""")
IP_MAPPING_FILE_NOT_EXISTS = single_line_message("""
    Internal error: IP mapping file '%s' does not exist.
""")
MIGRATION_LIST_FILE_EXISTS = single_line_message("""
    Internal error: Migration list file '%s' already exists.
""")
MIGRATION_LIST_IS_NOT_DEFINED = multi_line_message("""
    Internal error: Migration list is not defined.
""")
RSYNC_FAILED_COPY_FILES_FROM_SOURCE = multi_line_message("""
    Rsync failed to copy files from the source (%s) to the target server (%s): %s
    This could happen because of a network connection issue. Run migration for that subscription once more.
""")
FAILED_COPY_MAIL_CONTENT_OF_SUBSCRIPTION = single_line_message("""
    Failed to copy mail content of subscription. Most probably that happens because of a network-related issue.
    Check network connections between source and target servers, then run migration for that subscription once more.
""")
FAILED_COPY_DATABASE_CONTENT_OF_SUBSCRIPTION = single_line_message("""
    Failed to copy database content of subscription. Most probably that happens because of a network-related issue.
    Check network connections between source and target servers, then run migration for that subscription once more.
""")
SOURCE_TYPE_NOT_SUPPORTED = single_line_message("""
    Internal error: Panel source type '{source_type}' is not supported.
""")
TARGET_TYPE_NOT_SUPPORTED = single_line_message("""
    Internal error: Panel target type '{target_type}' is not supported.
""")
DISABLE_HIGH_LOG_PRIORITY = single_line_message("""
    Please change value of '{option_name}' option in {section_name} section in '{file_name}' file
    on {server_name} to '0'.
""")
FAILED_TO_CHECK_PLESK_API_INVALID_CREDENTIALS = single_line_message("""
    Internal error: Unable to login to Plesk API service of {server} due to incorrect login/password detected.
""")
INVALID_OPTION_VALUE = single_line_message("""
    Internal error: Invalid value for '{option_name}' option: '{specified_value}'.
    Please specify one of: {allowed_values}.
""")
SECTION_DOES_NOT_EXIST = single_line_message("""
    Internal error: Section '{section}' specified in '{option}' option does not exist in config.
""")
MSSQL_DATABASE_NATIVE_DUMP_NO_PHYSICAL_ACCESS = single_line_message("""
    Unable to migrate MSSQL database '%s' using native MSSQL backups: there is no direct access
    to the server with MSSQL server: {server}.
""")
EXCEPTION_FAILED_TO_READ_CONFIG_ABSENT_OPTION = single_line_message("""
    Internal error: failed to read configuration file. No option '%s' in section '[%s]'.
""")
FAILED_TO_READ_IP_MAPPING = multi_line_message("""
    Internal error: Failed to read IP mapping:
    %s
""")
INVALID_SSH_AUTH_VALUE = single_line_message("""
    Invalid type of SSH authentication was specified.
""")
SUBSCRIPTIONS_FAILED_TO_MIGRATE = multi_line_message("""
    {failed_subscriptions} of {total_subscriptions} subscription(s) failed to migrate.
""")
# No way to skip checks from GUI
HOW_TO_SKIP_DISK_SPACE_CHECK = ""
SSH_AUTH_NOT_SPECIFIED = multi_line_message("""
    SSH connection parameters are not specified for remote target Plesk server. Specify them and restart migration.
""")
NO_SSH_KEY_SUCCEEDED = multi_line_message("""
    Failed to connect to '{server}' with the following SSH key(s): {keys}.
    1) Make sure you have configured key-based authentication to the server '{server}'.
    For example, if you run "ssh {server} echo test", it should print "test" with no password prompt.
    2) If path to SSH keys that Plesk Migrator tried to use is not correct, correct paths.
""")
NO_SSH_KEYS_AVAILABLE = multi_line_message("""
    No appropriate SSH keys were found for server '{server}'. Specify path to correct private SSH key,
    or switch to password based authentication.
""")
