from parallels.core.utils.entity import Entity


class ExtensionModel(object):
    def get_list(self, filter_name=None):
        """Retrieve list of hosting panel extensions

        :type filter_name: list[str] | None
        :rtype: list[parallels.core.hosting_repository.extension.ExtensionEntity]
        """
        raise NotImplementedError()

    def make_backup(self, extension_id, backup_type, entity_id=None):
        """Backup given Plesk extension

        :type extension_id: int
        :type backup_type: str
        :type entity_id: int
        :rtype xml.etree.ElementTree.Element
        """
        raise NotImplementedError()

    def clear_backup_temp_data(self, extension_id, backup_type, entity_id=None):
        """Clean up temporary data created during backup step

        :type extension_id: int
        :type backup_type: str
        :type entity_id: int
        """
        raise NotImplementedError()

    def restore_backup(self, extension_backup_node, backup_type, entity_name=None, temp_content_path=None):
        """Restore given server level extension backup

        :type extension_backup_node: xml.etree.ElementTree.Element
        :type backup_type: str
        :type entity_name: str | None
        :type temp_content_path: str | None
        """
        raise NotImplementedError()


class ExtensionEntity(Entity):
    hook_names = [
        'server', 'server-post-backup',
        'reseller', 'reseller-post-backup',
        'customer', 'customer-post-backup',
        'subscription', 'subscription-post-backup',
        'site', 'site-post-backup',
    ]

    def __init__(self, extension_id, name, version, release):
        self._id = extension_id
        self._name = name
        self._version = version
        self._release = release
        self._hooks = {}

    @property
    def extension_id(self):
        return self._id

    @property
    def name(self):
        return self._name

    @property
    def version(self):
        return self._version

    @property
    def release(self):
        return self._release

    @property
    def hooks(self):
        return self._hooks

    def is_hook_available(self, hook):
        return self._hooks.get(hook, False)

    def set_hook(self, hook, is_available):
        self._hooks[hook] = is_available
