from parallels.core.utils.entity import Entity


class DomainAliasModel(object):
    def get_list(self):
        """Retrieve list of domain aliases in target panel

        :rtype: list[parallels.core.hosting_repository.domain_alias.DomainAliasEntity]
        """
        raise NotImplementedError()

    def create_from_dump(self, domain_alias_dump, domain_name):
        """Create domain alias in target panel

        :type domain_alias_dump: parallels.core.dump.data_model.DomainAlias
        :type domain_name: str
        """
        raise NotImplementedError()

    def is_exists(self, domain_alias_name):
        """Check if domain alias with given name or guid exists in target panel

        :type domain_alias_name: str
        :rtype: bool
        """
        raise NotImplementedError()


class DomainAliasEntity(Entity):
    def __init__(self, name, subscription_name):
        self._name = name
        self._subscription_name = subscription_name

    @property
    def name(self):
        return self._name

    @property
    def subscription_name(self):
        return self._subscription_name
