from parallels.core.utils.entity import Entity


class DnsRecordModel(object):
    def get_list(self, filter_domain_name=None, filter_type=None, filter_name=None):
        """Retrieve list of DNS records

        :type filter_domain_name: list[str] | None
        :type filter_type: list[str] | None
        :type filter_name: list[str] | None
        :rtype: list[parallels.core.hosting_repository.dns_record.DnsRecordEntity]
        """
        raise NotImplementedError()

    def remove(self, dns_record):
        """Remove given DNS record

        :type dns_record: parallels.core.hosting_repository.dns_record.DnsRecordEntity
        """
        raise NotImplementedError()


class DnsRecordEntity(Entity):
    TYPE_NS = 'NS'
    TYPE_A = 'A'
    TYPE_AAAA = 'AAAA'
    TYPE_CNAME = 'CNAME'
    TYPE_MX = 'MX'
    TYPE_TXT = 'TXT'
    TYPE_DS = 'DS'

    def __init__(self, record_type, record_name, record_data, domain_name):
        self._type = record_type
        self._name = record_name
        self._data = record_data
        self._domain_name = domain_name

    @property
    def type(self):
        return self._type

    @property
    def name(self):
        return self._name

    @property
    def data(self):
        return self._data

    @property
    def domain_name(self):
        return self._domain_name

    @property
    def pretty_name(self):
        return u'%s %s %s' % (self.name, self.type, self.data)
