from parallels.core.utils.entity import Entity


class CustomerModel(object):
    def get_list(self, filter_username=None):
        """Retrieve list of customers in target panel by given filter

        :type filter_username: list[str]
        :rtype: list[parallels.core.hosting_repository.customer.CustomerEntity]
        """
        raise NotImplementedError()

    def get_by_username(self, username):
        """Retrieve customer with given username from target panel

        :type username: str
        :rtype: parallels.core.hosting_repository.customer.CustomerEntity
        """
        customers = self.get_list(filter_username=[username])
        return customers.pop() if len(customers) > 0 else None

    def get_guid(self, customer_id):
        """Retrieve GUID of customer with specified ID

        :type customer_id: str | unicode
        :rtype: str | unicode | None
        """
        raise NotImplementedError()

    def disable_by_username(self, username):
        """Disable customer with given username in target panel

        :type username: str
        """
        raise NotImplementedError()

    def create(self, owner_username, customer):
        """Create given reseller in target panel; return id of created reseller and list detected errors

        :type owner_username: str | unicode | None
        :type customer: parallels.core.target_data_model.Client
        :rtype: int, list[str]
        """
        raise NotImplementedError()

    def set_external_id(self, username, external_id):
        """Set External ID for given customer in target panel

        :type username: str
        :type external_id: str
        """
        raise NotImplementedError()


class CustomerEntity(Entity):
    def __init__(self, customer_id, username, first_name, last_name, email, owner_id):
        self._id = customer_id
        self._username = username
        self._first_name = first_name
        self._last_name = last_name
        self._email = email
        self._owner_id = owner_id

    @property
    def customer_id(self):
        return self._id

    @property
    def username(self):
        return self._username

    @property
    def first_name(self):
        return self._first_name

    @property
    def last_name(self):
        return self._last_name

    @property
    def email(self):
        return self._email

    @property
    def owner_id(self):
        return self._owner_id
