from parallels.core.connections.database_servers.base import DatabaseServer
from parallels.core.utils.common import is_empty


class SourceDatabaseServer(DatabaseServer):
    """Source database server (either local or external) accessed from panel server"""
    def __init__(self, access_settings, model, panel_server):
        self._access_settings = access_settings
        self._model = model
        self._panel_server = panel_server

    def type(self):
        return self._model.dbtype

    def host(self):
        return self._model.host

    def port(self):
        return self._model.port

    def user(self):
        return self._model.login

    def password(self):
        if not is_empty(self._model.password):
            return self._model.password
        else:
            # Try to detect password
            return self.panel_server.get_database_server_password(self)

    @property
    def panel_server(self):
        return self._panel_server
