from parallels.core import messages, MigrationError
from parallels.core.actions.base.common_action import CommonAction


class DeployExtensionsNotSupported(CommonAction):
    def get_description(self):
        return messages.ACTION_DEPLOY_EXTENSIONS_NOT_SUPPORTED

    def get_failure_message(self, global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        return messages.ACTION_DEPLOY_EXTENSIONS_NOT_SUPPORTED_FAILED

    def run(self, global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        raise MigrationError(messages.ACTION_DEPLOY_EXTENSIONS_NOT_SUPPORTED_MESSAGE)
