
// Show popup dialog with settings to start migration.
// Arguments:
// - subscriptions - list of subscription names.
// - onSuccess - function that will be called once migration of these subscriptions is scheduled.
function showMigratePopup(subscriptions, onSuccess) {
    // compose title - it is different when one subscription is selected
    // and when multiple subscriptions are selected
    var title = '';
    if (subscriptions.length > 1) {
        title = formatMessage(MESSAGE_POPUP_MIGRATE_TITLE_MIGRATE_MULTIPLE, subscriptions.length);
    } else if (subscriptions.length == 1) {
        title = formatMessage(MESSAGE_POPUP_MIGRATE_TITLE_MIGRATE_SINGLE, subscriptions[0]);
    } else {
        // no subscriptions - no sense to show dialog
        return;
    }

    var popup = new Jsw.Popup({
        title: title,
        content: (
            '<div class="form-row">' +
                '<div class="field-name">' + MESSAGE_POPUP_MIGRATE_CONTENT + '</div>' +
                '<div class="field-value">' +
                    '<div>' +
                    '<input type="checkbox" class="checkbox" id="copyFiles" checked="checked"> ' +
                    '<label for="copyFiles">' +
                        MESSAGE_POPUP_MIGRATE_COPY_FILES +
                    '</label>' +
                    '</div>' +
                '<div>' +
                    '<input type="checkbox" class="checkbox" id="copyDatabases" checked="checked"> ' +
                    '<label for="copyDatabases">' +
                        MESSAGE_POPUP_MIGRATE_COPY_DATABASES +
                    '</label>' +
                '</div>' +
                '<div>' +
                    '<input type="checkbox" class="checkbox" id="copyMail" checked="checked"> ' +
                    '<label for="copyMail">' +
                        MESSAGE_POPUP_MIGRATE_COPY_MAIL +
                    '</label>' +
                    '</div>' +
                '</div>' +
            '</div>'
        ),
        buttons: [
            {
                id: 'migrateOkButton',
                title: MESSAGE_POPUP_MIGRATE_BUTTON_OK,
                class: 'action',
                handler: function (event, popup) {
                    var elemCopyFiles = $('copyFiles');
                    var elemCopyDatabases = $('copyDatabases');
                    var elemCopyMail = $('copyMail');

                    disableButtonInProgress($('migrateOkButton'), 'schedulingButtonTitle');
                    disableButtonPlain($('migrateCancelButton'));

                    new Ajax.Request(URL_MIGRATE_SUBSCRIPTIONS, {
                        parameters: {
                            subscriptions: Object.toJSON(subscriptions),
                            copyFiles: elemCopyFiles.checked,
                            copyDatabases: elemCopyDatabases.checked,
                            copyMail: elemCopyMail.checked
                        },
                        onSuccess: function (response) {
                            if (onSuccess) {
                                onSuccess();
                            }
                            popup.hide();
                        }
                    });
                }
            },
            {
                id: 'migrateCancelButton',
                title: MESSAGE_POPUP_MIGRATE_BUTTON_CANCEL,
                handler: function (event, popup) {
                    popup.hide();
                }
            }
        ],
        popupCls: 'popup-panel popup-panel-centered'
    });

    popup.show();
}