
migratorLocale = {
    _data: {},

    // Format locale message. Arguments:
    // - key - string key of locale message, check keys at "resources/locales/en-US.php"
    // - args - optional argument - dictionary with arguments to be substituted
    lmsg: function(key, args) {
        var message = this._data[key];
        if (args) {
            for (var argKey in args) {
                if (args.hasOwnProperty(argKey)) {
                    message = message.replace('%%' + argKey + '%%', args[argKey]);
                }
            }
        }
        return message;
    },

    // Add new locale messages.
    // Should be called when constructing page (in view script - views/*.phtml)
    // which uses these locale messages from JavaScript.
    addKeys: function(keys) {
        var self = this;
        Object.keys(keys).forEach(function(key) {
            self._data[key] = keys[key];
        });
    }
};