# Copyright 1999-2012. Parallels IP Holdings GmbH. All Rights Reserved.
package MiscConfigParser;

use strict;
eval{require warnings;1;};
use Logging;

sub parseApsIndexFile {
  my ( $file ) = @_;

  my %xmlHash;
  my $name;
  if ( open( FILE, $file ) ) {
    while (<FILE>) {
      chomp;
      if ( $_ =~ /<([A-Za-z\-]*)\s+name=\"(.*)\">/ ) {
        $name = $2;
      }
      elsif ( $_ =~ /<([A-Za-z\-]*)>(.*)<\/([A-Za-z\-]*)>/ ) {
        push @{ $xmlHash{$name} }, $2 unless $1 eq "valid";
      }
    }
    close FILE;
  }
  else {
    Logging::debug( "Aps index file " . $file . " is not exists. Skipping.");
  }
  return %xmlHash;
}

sub parseDrWebConfig {
  my ( $mailname ) = @_;
  my $drwebFile = "/etc/drweb/users.conf";
  unless ( open( DRWEBFILE, "<$drwebFile" ) ) {
    Logging::debug("Error: unable to open $drwebFile");
    return;
  }
  while (<DRWEBFILE>) {
    chomp;
    next if /^#/;      #skip comments
    next if /^\[/;
    next if /^\s*$/;
    my @parts = split /\s+/, $_, 4;
    if ( $parts[3] =~ /$mailname/ ) {
      if ( $parts[1] =~ /to/ ) {
        return 'in';
      }
      elsif ( $parts[1] =~ /from/ ) {
        return 'out';
      }
      else {
        return 'inout';
      }
      last;
    }
  }
  close(DRWEBFILE);
  return 'none';
}