from parallels.common.utils.restore_hosting_utils import restore_hosting_settings_lock
from parallels.plesks_migrator import messages
from parallels.common.actions.base.subscription_action import SubscriptionAction
from parallels.common.target_panels import TargetPanels
from parallels.common.utils import subscription_filter
from parallels.common.utils import plesk_utils


class RestoreDedicatedApplicationPool(SubscriptionAction):
	def filter_subscription(self, global_context, subscription):
		return (
			subscription_filter
				.windows_with_iis_dedicated_app_pool_enabled(
					subscription
				) 
			and 
			# Applicable only for PPA 11.5/11.6, consider to be removed in
			# further versions
			subscription.web_target_server.plesk_version < (12, 0)
		)

	def get_description(self):
		return messages.ACTION_RESTORE_DEDICATED_APPLICATION_POOL_DESCRIPTION

	def get_failure_message(self, global_context, subscription):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		return messages.ACTION_RESTORE_DEDICATED_APPLICATION_POOL_FAILURE % subscription.name

	def is_critical(self):
		"""If action is critical or not

		If action is critical and it failed for a subscription, migration tool
		won't run the next operations for the subscription.

		:rtype: bool
		"""
		return False

	def run(self, global_context, subscription):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		with restore_hosting_settings_lock:
			plesk_utils.change_dedicated_iis_app_pool_state(
				global_context.conn.target.plesk_server,
				subscription.name,
				True,
				plesk_restore_mode=global_context.target_panel != TargetPanels.PPA
			)
