from parallels.common.utils.backup_adapter import BackupAdapterBase


class CentralizedMailBackupIds(object):
	"""Gets list of centralized backup identifiers"""
	@staticmethod
	def get_backup_ids(global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		return global_context.conn.get_centralized_mail_servers().keys()


class CentralizedMailBackup(CentralizedMailBackupIds, BackupAdapterBase):
	def get(self, subscription):
		"""
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		return subscription.converted_mail_backup


class CentralizedMailBackupRaw(CentralizedMailBackupIds, BackupAdapterBase):
	def get(self, subscription):
		"""
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		return subscription.raw_mail_backup
