from parallels.common.actions.base.subscription_action import SubscriptionAction
from parallels.common.actions.hosting_settings.import_backups import ImportedBackups
from parallels.common.utils.restore_hosting_utils import get_restore_hosting_utils


class RestoreCentralizedMailHostingSettings(SubscriptionAction):
	def get_description(self):
		return "Restore centralized mail hosting settings of subscription"

	def filter_subscription(self, global_context, subscription):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		mail_backup_filename = subscription.full_converted_mail_backup.container.backup_info_file
		hosting_backup_filename = subscription.full_converted_backup.container.backup_info_file
		return (
			# if subscription does not exist in centralized mail backup - skip this action
			subscription.converted_mail_backup is not None
			and
			# if mail backup is the same as main backup - all settings will be restored
			# when restoring main backup, nothing to do in this action
			mail_backup_filename != hosting_backup_filename
		)

	def get_failure_message(self, global_context, subscription):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		return "Failed to restore centralized mail hosting settings of subscription '%s'" % subscription.name

	def is_critical(self):
		"""If action is critical or not

		If action is critical and it failed for a subscription, migration tool
		won't run the next operations for the subscription.

		:rtype: bool
		"""
		return False

	def run(self, global_context, subscription):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		imported_backup = ImportedBackups.get_instance().get_by_backup(subscription.full_converted_mail_backup)
		subscription_backup_xml = imported_backup.get_domain_xml_path(subscription.name)

		restore_hosting_utils = get_restore_hosting_utils(global_context.conn.target.plesk_server)

		restore_hosting_utils.restore_hosting_settings(
			subscription.name, subscription_backup_xml, global_context.safe,
			settings_description=u"hosting settings",
			disable_apsmail_provisioning=subscription.is_mail_assimilate
		)