import logging

from parallels.common.actions.base.common_action import CommonAction
from parallels.custom_panel_migrator.backup_creator import BackupCreator

logger = logging.getLogger(__name__)


class CreateFromLight(CommonAction):
	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:rtype: basestring
		"""
		return 'Failed to create full backup dump out of light backup dump'

	def get_description(self):
		"""
		:rtype: basestring
		"""
		return 'Create full backup dump out of light backup dump'

	def run(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:rtype: None
		"""
		backup_creator = BackupCreator()
		conn = global_context.conn
		""":type conn: parallels.custom_panel_migrator.connections.MigratorConnections"""
		for light_backup_config in conn.iter_source_light_backup_paths():
			logger.info("Create full backup for '%s'", light_backup_config.source_id)

			backup_creator.write_full_backup(
				light_backup_config.path,
				light_backup_config.file_format,
				global_context.session_files.get_path_to_full_backup_created_from_light(light_backup_config.source_id)
			)