from parallels.common.workflow.shared_hosting_workflow \
	import SharedHostingWorkflow

from parallels.common.actions.base.legacy_action \
	import LegacyAction

from parallels.cpanel_migrator.actions.content.web.copy_unix_content \
	import CpanelCopyUnixWebContent
from parallels.common.actions.content.web.fix_unix_vhost_permissions \
	import FixUnixVhostPermissions
from parallels.cpanel_migrator.actions.content.web.fix_unix_permissions \
	import FixUnixPermissions


class FromCpanelWorkflow(SharedHostingWorkflow):
	def __init__(self):
		super(FromCpanelWorkflow, self).__init__()

		self.get_shared_action('fetch-source').insert_action(
			'fetch-data', LegacyAction(
				description='Fetch data from source cPanel',
				function=lambda ctx: ctx.migrator._fetch_source(
					ctx.options, ctx.options.reload_source_data
				)
			)
		)
		self.get_shared_action('copy-web-files').insert_action(
			'copy-files', CpanelCopyUnixWebContent()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'fix-unix-vhost-permissions', FixUnixVhostPermissions()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'fix-permissions', FixUnixPermissions()
		)
