class Registry(object):

	_instance = None

	def __init__(self):
		self._entries = {}

	def set_context(self, context):
		"""
		Store global context in registry and return it
		:param parallels.common.global_context.GlobalMigrationContext context: global migration context
		:rtype: parallels.common.global_context.GlobalMigrationContext
		"""
		return self._set('context', context)

	def get_context(self):
		"""
		Restore global context from registry and return it
		:rtype: parallels.common.global_context.GlobalMigrationContext
		"""
		return self._get('context')

	def set_base_dir(self, base_dir):
		"""
		Store base panel migrator directory in registry and return it
		:param basestring base_dir: base panel migrator directory
		:rtype: basestring
		"""
		return self._set('base_dir', base_dir)

	def get_base_dir(self):
		"""
		Restore base panel migrator directory from registry and return it
		:rtype: str
		"""
		return self._get('base_dir')

	def _set(self, name, value):
		self._entries[name] = value
		return self._entries[name]

	def _get(self, name):
		return self._entries.get(name)

	@classmethod
	def get_instance(cls):
		"""
		Obtain instance of registry (singleton) and return it
		:rtype: parallels.common.registry.Registry
		"""
		if cls._instance is None:
			cls._instance = Registry()
		return cls._instance