from parallels.common import messages
import logging

from parallels.common.actions.base.subscription_backup_action import SubscriptionBackupAction
from parallels.common.actions.utils.logging_properties \
	import LoggingProperties

logger = logging.getLogger(__name__)


class RemoveSubscriptionExternalId(SubscriptionBackupAction):
	"""Remove external ID for all subscriptions, so that they won't override
	ones assigned by PPA during hosting restoration process."""

	def get_description(self):
		return messages.REMOVE_EXTERNAL_IDS_FROM_BACKUP

	def get_failure_message(self, global_context, subscription):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		return messages.FAILED_REMOVE_EXTERNAL_IDS_FOR_SUBSCRIPTION % subscription.name

	def get_logging_properties(self):
		return LoggingProperties(info_log=False)

	def _run_subscription_backup(
		self, global_context, subscription, subscription_backup
	):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		logger.debug(messages.DELETE_SUBSCRIPTIONS_EXTERNAL_ID)
		subscription_backup.delete_external_id()
