from parallels.common import messages
from textwrap import dedent

from parallels.common.actions.base.common_action import CommonAction
from parallels.common import MigrationError


class CheckTargetPanelSupportsForwarding(CommonAction):
	def get_description(self):
		return messages.CHECK_IF_TARGET_PANEL_SUPPORTS_DNS

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		return messages.FAILED_CHECK_IF_TARGET_PANEL_SUPPORTS_1

	def run(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		if not global_context.target_panel_obj.has_dns_forwarding():
			raise MigrationError(dedent(messages.DNS_FORWARDING_IS_NOT_SUPPORTED_WHEN))
