from parallels.common.actions.content.web.copy_windows_content_base import CopyWindowsWebContentBase
from parallels.common.utils import windows_utils
from parallels.plesks_migrator.actions.content.web.utils import list_security_files
from parallels.utils import obj


class CopyWindowsWebContent(CopyWindowsWebContentBase):
	def _list_files_to_copy(self, global_context, subscription):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		vhost_name = subscription.name_idn
		source_server = subscription.web_source_server

		security_files = list_security_files(subscription, include_subdomains=False)

		target_logs_subdir = u"%s/logs" % vhost_name
		tocopy = [
			# content
			obj(
				source_filename=vhost_name + '/',
				target_filename=vhost_name,
				exclude=[u"/statistics", u"/subdomains"] + ["/%s" % security_file for security_file in security_files],
				skip_if_source_not_exists=False
			),
			# subscription logs
			obj(
				source_filename=u"%s/statistics/logs/" % vhost_name,
				target_filename=target_logs_subdir,
				exclude=[],
				skip_if_source_not_exists=True
			),
			obj(
				source_filename=u"%s/logs/" % vhost_name,
				target_filename=target_logs_subdir,
				exclude=[],
				skip_if_source_not_exists=True
			),
			# subscription statistics
			obj(
				source_filename=u"%s/statistics/" % vhost_name,
				target_filename=u"%s/.plesk/statistics/%s" % (vhost_name, vhost_name),
				exclude=[u"/logs"],
				skip_if_source_not_exists=True
			),
			# ".Security" files
			obj(
				source_filename=u"%s/.Security" % vhost_name,
				target_filename=u"%s/.plesk/.Security" % vhost_name,
				exclude=[],
				skip_if_source_not_exists=True
			),
			obj(
				source_filename=u"%s/.plesk/.Security" % vhost_name,
				target_filename=u"%s/.plesk/.Security" % vhost_name,
				exclude=[],
				skip_if_source_not_exists=True
			),
		]

		for security_file in security_files:
			tocopy.append(obj(
				source_filename=u"%s/%s" % (vhost_name, security_file),
				target_filename=u"%s/.plesk/%s" % (vhost_name, security_file),
				exclude=[],
				skip_if_source_not_exists=True
			))

		for site in subscription.converted_backup.iter_sites():
			if source_server.plesk_version > (12, 1):
				raise NotImplementedError()

			site_vhost_name = site.name.encode('idna')
			target_stats_subdir = u"%s/.plesk/statistics/%s" % (vhost_name, site_vhost_name)

			if source_server.plesk_version >= (12, 0):  # Plesk 12.x
				tocopy.extend([
					# site statistics
					obj(
						source_filename=u"%s/.plesk/statistics/%s" % (vhost_name, site_vhost_name),
						target_filename=target_stats_subdir,
						exclude=[],
						skip_if_source_not_exists=True
					),
				])
			elif source_server.plesk_version >= (10, 0):  # Plesk 10 and 11
				source_logs_subdir = u"%s/statistics/logs" % site_vhost_name
				tocopy.extend([
					# site logs
					obj(
						source_filename=source_logs_subdir,
						target_filename=target_logs_subdir,
						exclude=[],
						skip_if_source_not_exists=True
					),
					# site statistics
					obj(
						source_filename=u"%s/statistics" % site_vhost_name,
						target_filename=target_stats_subdir,
						exclude=[u"/%s" % source_logs_subdir],
						skip_if_source_not_exists=True),
				])
			else:
				# Plesk 8 and 9
				if site.hosting_type == 'vrt_hst':
					# subdomains with physical hosting (living under subdomains/)
					# have separate stats and logs, that need to be copied
					source_site_subdir = "%s/subdomains/%s/" % (vhost_name, site.short_name.encode('idna'))
					source_stats_subdir = u"%s/statistics/" % source_site_subdir
					source_logs_subdir = u"%s/statistics/logs/" % source_site_subdir
					tocopy.extend([
						# subdomain logs
						obj(
							source_filename=source_logs_subdir,
							target_filename=target_logs_subdir,
							exclude=[],
							skip_if_source_not_exists=True
						),
						# subdomain stats
						obj(
							source_filename=source_stats_subdir,
							target_filename=target_stats_subdir,
							exclude=[u"/%s" % source_logs_subdir],
							skip_if_source_not_exists=True
						),
					])
					# copy all remaining stuff as content
					tocopy.extend([
						obj(
							source_filename=source_site_subdir,
							target_filename=source_site_subdir,
							exclude=[u"/%s" % source_stats_subdir],
							skip_if_source_not_exists=False
						)
					])
				else:
					# Subdomains with subdir hosting (living under httpdocs/)
					# do not have separate stats, but have separate log
					# Logs will be copied automatically with subscription's logs
					pass
					# TODO map log's directory (e.g. W3SVC45 to W3SVC54 according to its source and target IIS site ids)

		# filter off all files that do not exist on source and are not required
		tocopy_filtered = []

		with source_server.runner() as runner_source:
			for item in tocopy:
				if item.skip_if_source_not_exists:
					full_source_path = windows_utils.path_join(source_server.vhosts_dir, item.source_filename)
					if not windows_utils.file_exists(runner_source, full_source_path):
						# file does not exist on source, skip it
						continue
				tocopy_filtered.append(item)

		return tocopy_filtered