from parallels.hosting_check.messages.utils import format_message
from parallels.hosting_check import FTPAuthIssueType

MESSAGES = {}

MESSAGES[FTPAuthIssueType.WEB_IP_NOT_DEFINED] = format_message("""
Make sure that:
1. The subscription is present in the target Plesk.
2. Virtual hosting is enabled for the subscription in the target Plesk.
""")

MESSAGES[FTPAuthIssueType.CHECK_FAILED] = format_message("""
Make sure that:
1. The proper username and password are specified for the subscription in the target Plesk.
2. The FTP service is operating properly on the target Plesk.

Ignore this warning if you have changed login or password of the system user after transfer.
""")

MESSAGES[FTPAuthIssueType.INTERNAL_ERROR] = format_message("""
u"Check whether it is possible to log in to the subscription on the target Plesk by FTP."
""")
