from parallels.common.actions.base.subscription_backup_action import SubscriptionBackupAction
from parallels.common.actions.utils.logging_properties \
	import LoggingProperties
from parallels.common.target_panels import TargetPanels


class RemoveSmartermailUnsupportedFeatures(SubscriptionBackupAction):
	def get_description(self):
		return "Remove features that are not supported by SmarerMail from backup"

	def get_failure_message(self, global_context, subscription):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		return "Failed to remove features that are not supported by SmarerMail for subscription '%s'" % (
			subscription.name
		)

	def get_logging_properties(self):
		return LoggingProperties(info_log=False)

	def is_critical(self):
		"""If action is critical or not

		If action is critical and it failed for a subscription, migration tool
		won't run the next operations for the subscription.

		:rtype: bool
		"""
		return False

	def _run_subscription_backup(
		self, global_context, subscription, subscription_backup
	):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		if global_context.target_panel != TargetPanels.PPA:
			# applicable to PPA only, for Plesk we can restore all these mail
			# settings (antivirus, antispam, greylisting)
			return

		if subscription.mail_target_server is None:
			return
		if not subscription.mail_target_server.is_windows():
			return

		if subscription_backup.mailsystem is not None:
			subscription_backup.mailsystem.remove_greylisting()

		for mailbox in subscription_backup.iter_mailboxes():
			mailbox.remove_spamassassin()
			mailbox.remove_virusfilter()
