package PanelConfigFile;

use strict;
use warnings;

use Parser;
use Logging;

sub getContents {
  my ($siteId, $infoFileName, $infoName, %defaultSettings) = @_;

  my $fileName = getConfigFileName($siteId, $infoFileName);
  my %info = %{ _readConfigFile($fileName) };
  my @infoTextDump = map { "$_ => $info{$_}\n" } keys %info;
  while (my($setting, $value) = each %defaultSettings) {
    unless (exists $info{$setting} ) {
      $info{$setting} = $value;
      Logging::warning("Cannot find the parameter '$setting' in config file '$infoFileName'. Using the default value '$value'");
    }
  }

  $infoName = $infoFileName unless $infoName;
  Logging::trace("$infoName for '$siteId' site is \n @infoTextDump");
  return %info;
}

sub _readConfigFile {
  my ($fileName) = @_;

  my $configReader = Parser::makeSafeFileParser($fileName);

  if ( defined $configReader ) {
    return $configReader->{'PARSE'}->(
      'KEYSEPARATOR' => '=',
      'COMMENT'      => '\[DEFAULT\]'
    );
  }
  else {
    return { "enabled" => 0 };
  }
}

sub getConfigFileName {
  my ( $siteId, $fileName ) = @_;
  return getSiteinfoFileName($siteId) . "/current/$fileName";
}

sub getSiteinfoFileName {
  my ($siteId) = @_;

  return "/home/virtual/site$siteId/info";
}
1;
