from parallels.common.actions.base.subscription_action import SubscriptionAction
from parallels.common.converter import dns as dns_converter

class DNS(SubscriptionAction):
	def get_description(self):
		return "Convert DNS records"

	def get_failure_message(self, global_context, subscription):
		return "Failed to convert DNS records for subscription '%s'" % (subscription.name)

	def filter_subscription(self, global_context, subscription):
		return True

	def run(self, global_context, subscription):
		"""Make subscription DNS records resolve to target server IP."""
		dns_converter.replace_resource_record_ips(subscription)
