from parallels.plesks_migrator.workflow import FromPleskWorkflow

from parallels.common.actions.base.legacy_action \
	import LegacyAction

from parallels.expand_migrator.actions.hosting_settings.convert.dns \
	import DNS as ActionHostingSettingsConvertDNS
from parallels.expand_migrator.actions.fetch.fetch_backup_cmail import \
		FetchCentralizedMailBackupAction
from parallels.common.actions.backup.create_converted \
	import CreateConverted
from parallels.common.actions.backup.save_converted \
	import SaveConverted
from parallels.common.actions.backup.remove_content \
	import RemoveContent
from parallels.common.actions.hosting_settings.convert.remap_databases \
	import RemapDatabases
from parallels.common.actions.hosting_settings.convert.remove_subscription_to_plan_relation \
	import RemoveSubscriptionToPlanRelation
from parallels.common.actions.hosting_settings.convert.remove_subscription_default_db_server \
	import RemoveSubscriptionDefaultDBServer
from parallels.common.actions.hosting_settings.convert.remove_subscription_limits_and_permissions \
	import RemoveSubscriptionLimitsAndPermissions
from parallels.common.actions.hosting_settings.convert.remove_maillists \
	import RemoveMaillists
from parallels.common.actions.hosting_settings.convert.remove_domain_keys \
	import RemoveDomainKeys
from parallels.common.actions.hosting_settings.convert.change_webmail_to_horde \
	import ChangeWebmailToHorde
from parallels.common.actions.hosting_settings.convert.remove_disabled_mailsystem_without_resource \
	import RemoveDisabledMailsystemWithoutResource
from parallels.common.actions.hosting_settings.convert.change_catch_all_redirect \
	import ChangeCatchAllRedirect
from parallels.common.actions.hosting_settings.convert.change_subscription_ips \
	import ChangeSubscriptionIPs
from parallels.common.actions.hosting_settings.convert.remove_subscription_external_id \
	import RemoveSubscriptionExternalId
from parallels.common.actions.hosting_settings.convert.change_sysuser_password \
	import ChangeSysuserPassword
from parallels.common.actions.hosting_settings.convert.change_smartermail_password \
	import ChangeSmartermailPassword
from parallels.common.actions.hosting_settings.convert.remove_smartermail_unsupported_features \
	import RemoveSmartermailUnsupportedFeatures
from parallels.common.actions.hosting_settings.convert.change_sysuser_login \
	import ChangeSysuserLogin
from parallels.common.actions.hosting_settings.check.catch_all_redirect \
	import CatchAllRedirect
from parallels.common.actions.hosting_settings.check.email_empty_password \
	import EmailEmptyPassword
from parallels.common.actions.hosting_settings.check.maillists \
	import Maillists

from parallels.expand_migrator.utils.backup_adapter \
	import CentralizedMailBackup
from parallels.expand_migrator.utils.backup_adapter \
	import CentralizedMailBackupRaw

class FromExpandWorkflow(FromPleskWorkflow):
	def __init__(self):
		super(FromExpandWorkflow, self).__init__()

		self.get_shared_action('fetch-source').insert_action(
			'fetch-expand', LegacyAction(
				'fetch-expand', 
				lambda ctx: ctx.migrator._fetch_expand()
			)
		)
		self.get_shared_action('fetch-source').insert_action(
			'fetch-centralized-mail', FetchCentralizedMailBackupAction()
		)
		
		convert_hosting = self.get_path('transfer-accounts/restore-hosting/convert-hosting')
		convert_hosting.replace(
			'convert-dns', ActionHostingSettingsConvertDNS()
		)
		convert_hosting.insert_actions([
			('cmail-create-converted-backup', CreateConverted(CentralizedMailBackup())),
			('cmail-remap-databases', RemapDatabases(CentralizedMailBackup())),
			('cmail-remove-subscription-to-plan-relation', RemoveSubscriptionToPlanRelation(CentralizedMailBackup())),
			('cmail-remove-subscription-default-db-server', RemoveSubscriptionDefaultDBServer(CentralizedMailBackup())),
			('cmail-remove-subscription-limits-and-permissions', RemoveSubscriptionLimitsAndPermissions(CentralizedMailBackup())),
			('cmail-remove-maillists', RemoveMaillists(CentralizedMailBackup())),
			('cmail-remove-domain-keys', RemoveDomainKeys(CentralizedMailBackup())),
			('cmail-change-webmail-to-horde', ChangeWebmailToHorde(CentralizedMailBackup())),
			('cmail-remove-disabled-mailsystem-without-resource', RemoveDisabledMailsystemWithoutResource(CentralizedMailBackup())),
			('cmail-change-catch-all-redirect', ChangeCatchAllRedirect(CentralizedMailBackup())),
			('cmail-change-subscription-ips', ChangeSubscriptionIPs(CentralizedMailBackup())),
			('cmail-remove-subscription-external-id', RemoveSubscriptionExternalId(CentralizedMailBackup())),
			('cmail-change-sysuser-password', ChangeSysuserPassword(CentralizedMailBackup())),
			('cmail-change-smartermail-password', ChangeSmartermailPassword(CentralizedMailBackup())),
			('cmail-remove-smartermail-upsupported-features', RemoveSmartermailUnsupportedFeatures(CentralizedMailBackup())),
			('cmail-restore-sysuser-logins', ChangeSysuserLogin(CentralizedMailBackup())),
			('cmail-backup-remove-content', RemoveContent(CentralizedMailBackup())),
			('cmail-save-backup', SaveConverted(CentralizedMailBackup())),
			('cmail-check-catch-all-redirect', CatchAllRedirect(CentralizedMailBackup())),
			('cmail-check-email-empty-password', EmailEmptyPassword(CentralizedMailBackup())),
			('cmail-check-maillists', Maillists(CentralizedMailBackup())),
		])

		self.get_path('check/check-data').insert_action(
			'check-cmail-catch-all-redirect',
			CatchAllRedirect(CentralizedMailBackupRaw())
		)
		self.get_path('check/check-data').insert_action(
			'check-,mail-email-empty-password',
			EmailEmptyPassword(CentralizedMailBackupRaw())
		)
		self.get_path('check/check-data').insert_action(
			'check-cmail-maillists',
			Maillists(CentralizedMailBackupRaw())
		)
