from parallels.ppa import messages
from parallels.core.actions.base.subscription_backup_action import SubscriptionBackupAction
from parallels.core.actions.utils.logging_properties \
	import LoggingProperties
from parallels.core.checking import Problem


class Maillists(SubscriptionBackupAction):
	"""Check if there are maillists in backup
	
	PPA doesn't support Mailman yet, warn user that we can't restore them.
	"""
	def get_description(self):
		return messages.ACTION_CHECK_MAILLISTS

	def get_failure_message(self, global_context, subscription):
		return messages.FAILED_CHECK_FOR_MAILLISTS_FOR_SUBSCRIPTION % (subscription.name)

	def is_critical(self):
		"""If action is critical or not

		If action is critical and it failed for a subscription, migration tool
		won't run the next operations for the subscription.

		:rtype: bool
		"""
		return False

	def get_logging_properties(self):
		return LoggingProperties(info_log=False)

	def _run_subscription_backup(
		self, global_context, subscription, subscription_backup
	):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		"""
		if subscription_backup.has_maillists():
			subscription.add_report_issue(
				global_context.pre_check_report,
				Problem(
					'subscription_has_maillists', Problem.WARNING, 
					messages.SUBSCRIPTION_SOME_MAIL_LISTS_MAIL_LISTS),
				messages.MAIL_LISTS_WONT_BE_MIGRATED
			)
