# Copyright 1999-2015. Parallels IP Holdings GmbH. All Rights Reserved.
package LegacyPanel::Tree::Util;

use strict;
use warnings;

use Tree::Simple::Visitor;

sub getNodePath($) {
  my ($tree) = @_;

  my @result = ();

  if ($tree->isa('Tree::Simple')) {
    my $parent = $tree;
    while (!($parent->isRoot())) {
      unshift(@result, $parent);
      $parent = $parent->getParent();
    }
  }

  return @result;
}

sub applyVisitor($\&) {
  my ($tree, $codeRef) = @_;

  my @results = ();

  if ($tree->isa('Tree::Simple')) { 
    my $visitor = Tree::Simple::Visitor->new();
    $visitor->setNodeFilter($codeRef);
    $tree->accept($visitor);
    @results = $visitor->getResults();
  }

  return @results;
}

1;
