# Administrator's ID for internal data models of migrator
ADMIN_ID = 1

# Type of Panel Migrator installation via own installer as standalone product
INSTALLATION_TYPE_STANDALONE = 'STANDALONE'

IP_EXCLUSIVE = 'exclusive'
IP_SHARED = 'shared'

# Indicator meaning that we have no information about source database server
# so we should not try to copy database content for that database
DATABASE_NO_SOURCE_HOST = 'NO_SOURCE_HOST'

PLESK_PANEL_DEFAULT_PORT = 8443
SSH_DEFAULT_PORT = 22

# Default path to migrator's session directory on source Windows server.
# Keep it short to avoid issues with long paths.
WINDOWS_SOURCE_DEFAULT_SESSION_DIR = r'C:\migrator'

# Default path to migrator's session directory on source Unix server.
UNIX_SOURCE_DEFAULT_SESSION_DIR = '/tmp'

# Default path to migrator's session directory on remote target Windows server.
# By remote we mean that server where migrator is running and target Windows server are different servers.
# Keep it short to avoid issues with long paths.
WINDOWS_REMOTE_TARGET_DEFAULT_SESSION_DIR = r'C:\migrator'