from parallels.core.hosting_check.entity_source.service import TargetServiceInfo
from parallels.core.subscription_target_info import TargetServices, TargetServers
from parallels.core.subscription_target_info import SubscriptionServiceIPs
from parallels.plesk.client_subscription_converter import TargetPleskClientSubscriptionConverterAdapter
from parallels.plesk.import_api.import_api_unix import PleskUnixImportAPI
from parallels.plesk.import_api.import_api_windows import PleskWindowsImportAPI
from parallels.ppa.panel import Panel as PPAPanel
from parallels.shm_web_sn import messages
from parallels.shm_web_sn.connections.target_connections import PPAWebSNTargetConnections
from parallels.shm_web_sn.connections.target_server import PPAMoveWebspacesTargetServer
from parallels.core.utils.common import cached


class Panel(PPAPanel):
	@property
	def name(self):
		return messages.PPA_WEB_SN

	def has_dns_forwarding(self):
		"""Whether panel should support DNS forwarding migration feature"""
		return False

	def is_write_failed_subscriptions_list(self):
		"""Whether to write failed subscriptions list file after migration

		:rtype: bool
		"""
		return False

	def get_subscription_target_services(self, global_context, subscription_name):
		"""Get location of subscriptions's hosting services on target panel

		:type global_context: parallels.shm_web_sn.source.shm_web_sn.global_context.PPAMoveWebspacesGlobalMigrationContext
		:type subscription_name: basestring
		:rtype: parallels.core.subscription_target_info.TargetServices
		"""
		return TargetServices(
				web_ips=SubscriptionServiceIPs(
					v4=global_context.webspace_ipv4,
					v6=global_context.webspace_ipv6
				),
				mail_ips=SubscriptionServiceIPs(),
				db_servers={},
				dns_ips=[SubscriptionServiceIPs()]
			)

	@cached
	def get_subscription_nodes(self, global_context, subscription_name):
		"""Get servers of subscription on target panel

		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription_name: basestring
		:rtype: parallels.core.subscription_target_info.TargetServers
		"""
		conn = global_context.conn.target

		return TargetServers(
			web=self._get_target_server(conn),
			mail=None,
			database={},
			dns=[]
		)

	def get_service_nodes(self, conn):
		return [
			TargetServiceInfo(
				service_type='web',
				node=self._get_target_server(conn)
			)
		]

	def get_subscription_plesk_node(self, global_context, subscription_name):
		conn = global_context.conn.target
		return self._get_target_server(conn)

	def get_connections(self, global_context):
		"""Get target panel connections"""
		return PPAWebSNTargetConnections(global_context.config)

	def get_import_api(self, global_context):
		if global_context.conn.target.is_windows:
			return PleskWindowsImportAPI(global_context.conn.target)
		else:
			return PleskUnixImportAPI(global_context.conn.target)

	def get_converter_adapter(self):
		"""
		:rtype: parallels.core.client_subscription_converter.ClientSubscriptionConverterAdapter
		"""
		return TargetPleskClientSubscriptionConverterAdapter()

	def get_hosting_check_messages_panel_id(self):
		return 'plesk'

	@cached
	def _get_target_server(self, conn):
		return PPAMoveWebspacesTargetServer(conn)
