from parallels.core.checking import PlainReport
from parallels.core.client_subscription_converter import ClientSubscriptionConverterAdapter
from parallels.ppa.source.expand.converter.clients_subscriptions import \
	ExpandToPPAClientsAndSubscriptionsConverter


class ExpandToPPAClientSubscriptionConverterAdapter(ClientSubscriptionConverterAdapter):
	def convert(self, global_context, converted_resellers, report):
		"""
		:type global_context: parallels.plesk.source.expand.global_context.ExpandGlobalMigrationContext
		"""
		plain_report = PlainReport(report, *global_context.migrator._extract_source_objects_info())
		mail_servers = {
			plesk_id: global_context.migrator._get_source_servers()[
				global_context.migrator._get_mail_server_id(plesk_id)
			]
			for plesk_id in global_context.migrator.source_servers.iterkeys()
		}
		converter = ExpandToPPAClientsAndSubscriptionsConverter(
			global_context.conn.target.panel_admin_password, global_context.target_existing_objects,
			global_context.expand_data, global_context.options, global_context.migrator.multiple_webspaces
		)
		converter.convert_dumps(
			global_context.get_source_servers_info(), plain_report,
			global_context.migration_list_data.subscriptions_mapping,
			global_context.migration_list_data.customers_mapping,
			converted_resellers, global_context.password_holder, mail_servers
		)
		# Extract information about mail aux users from centralized mail backups
		# put extracted users under corresponding customer/subscription extracted earlier from hosting Plesks
		converter.extract_aux_users(
			global_context.get_sources_info(global_context.migrator.centralized_mail_servers),
			report, global_context.password_holder
		)
		converter.fix_emails_of_aux_users()
		return converter.get_target_model()
