from parallels.core.registry import Registry
from parallels.core import migrator_config
from parallels.core.migrator_config import ActionRunnerType
from parallels.core.workflow.runner.by_layer import ActionRunnerByLayer
from parallels.core.workflow.runner.by_subscription import ActionRunnerBySubscription


def create_action_runner():
	"""Create runner according current configuration
	"""
	config = Registry.get_instance().get_context().config
	action_runner_type = migrator_config.read_action_runner_type(config)
	multithreading = migrator_config.read_multithreading_params(config)

	if action_runner_type == ActionRunnerType.BY_LAYER:
		return ActionRunnerByLayer(multithreading)
	elif action_runner_type == ActionRunnerType.BY_SUBSCRIPTION:
		return ActionRunnerBySubscription(multithreading)
	else:
		assert False