# Copyright 1999-2012. Parallels IP Holdings GmbH. All Rights Reserved.
package ConfixxConfig;

# 'use strict' is not used here, as we execute Confixx config file, which is a regular Perl script
# with variables that don't have 'my' in their declarations
use warnings;

use Logging;
use ConfixxConfigPath;

my $configLoaded = 0;

sub getValue {
  my ($varName) = @_;

  unless ($varName) {
    Logging::warning("Attempt to get Confixx config variable by undefined name");
    return undef;
  }

  unless ($configLoaded) {
    _loadMainConfig();
  }

  # at this point, either config is loaded or program is terminated, don't check it again

  return eval "\$$varName";
}

sub _loadMainConfig {
  if (!$configLoaded) {
    my $path = ConfixxConfigPath::getConfixxMainConfigPath();
    if (!defined($path)) {
      Logging::error("Confixx config was not found");
      die; # absence of config is critical error, don't go any further
    }

    Logging::debug("Found Confixx config at $path, loading");

    do $path;

    $configLoaded = 1;
  }

  return 1;
}

1;
