import os

from parallels.core import messages
from parallels.core.registry import Registry
from parallels.core.utils import get_thirdparties_base_path
from parallels.core.utils.common import is_run_on_windows


def get_paexec_bin():
	"""Location of paexec.exe - utility to run commands on remote Windows"""
	return os.path.join(get_thirdparties_base_path(), "paexec.exe")


def get_rsync_bin():
	"""Location of panel-migrator-rsync.exe - utility to download files from remote server"""
	return os.path.join(get_thirdparties_base_path(), "rsync/panel-migrator-rsync.exe")


def get_rsync_installer_bin():
	return os.path.join(get_thirdparties_base_path(), 'panel-migrator-rsync-installer.exe')


def get_rsync_for_source_server_installer():
	"""Get installer binary for rsync on source servers"""
	return os.path.join(get_thirdparties_base_path(), "rsync-for-source-server.exe")


def get_transfer_agent_dir():
	if not is_run_on_windows():
		raise Exception(messages.UNABLE_GET_PANEL_MIGRATOR_TRANSFER_AGENT)
	return os.path.join(Registry.get_instance().get_var_dir(), 'agents', 'transfer-agent')