from parallels.core.actions.base.compound_action import CompoundAction
from parallels.core.actions.content.web.fix_unix_vhost_permissions import FixUnixVhostPermissions
from parallels.core.workflow.extension import WorkflowExtensionBase
from parallels.plesk.source.plesk.actions.aps.restore_applications import RestoreApplications
from parallels.plesk.source.plesk.actions.content.web.copy_unix_content import CopyUnixWebContent
from parallels.plesk.source.plesk.actions.content.web.fix_security_files import FixSecurityFiles
from parallels.plesk.source.plesk.actions.content.web.fix_unix_permissions import FixUnixPermissions
from parallels.plesk.source.plesk.actions.content.web.fix_unix_permissions_old_plesk import FixUnixPermissionsOldPlesks
from parallels.plesk.source.plesk.actions.content.web.fix_unix_vhost_structure import FixUnixVhostStructure
from parallels.plesk.source.plesk.actions.content.web.reset_permissions import ResetPermissions
from parallels.plesk.source.plesk.actions.hosting_settings.transfer_error_documents import TransferErrorDocuments
from parallels.plesk.source.plesk.actions.hosting_settings.transfer_mime_types import TransferMIMETypes
from parallels.plesk.source.plesk.actions.hosting_settings.transfer_virtual_directories \
	import TransferVirtualDirectories
from parallels.plesk.source.plesk.actions.wpb.transfer import Transfer as TransferWPBSites
from parallels.shcm_web_sn.source.shcm_web_sn.actions.fetch_dump import FetchDumpAction
from parallels.shcm_web_sn.source.shcm_web_sn.actions.fetch_target import FetchTargetAction
from parallels.shcm_web_sn.source.shcm_web_sn.actions.migration_list.load_move_list import LoadMoveListAction


class WorkflowExtension(WorkflowExtensionBase):
	def extend_workflow(self, workflow):
		"""Extend shared hosting workflow with source-panel specific actions

		:type workflow: parallels.core.workflow.base_workflow.BaseWorkflow
		"""
		workflow.insert_first_shared_action_to_all_entries('load-move-list', LoadMoveListAction())
		workflow.get_shared_action('fetch-source').insert_action('fetch-data', FetchDumpAction())

		workflow.replace_shared_action('fetch-target', FetchTargetAction())

		# No need to check connections because we are migrating webspaces using single host in most cases
		workflow.replace_shared_action('check-connections', CompoundAction())
		# No license check is needed since we are migrating webspaces between hosts in the same PPA instance
		workflow.replace_shared_action('check-target-licenses', CompoundAction())

		# We do not support windows hosts at all in SHCM right now
		workflow.get_path('transfer-accounts').replace('set-windows-security-policy', CompoundAction())
		workflow.get_path('transfer-accounts').replace('restore-windows-security-policy', CompoundAction())

		# All import and restoration will be performed by pmmcli
		workflow.get_path('transfer-accounts/restore').replace('import-clients-and-subscriptions', CompoundAction())
		workflow.get_path('transfer-accounts/restore-hosting').replace('restore-sysuser-logins', CompoundAction())

		# DNS isn't affected by webspace migration in SHCM
		workflow.get_path('transfer-accounts/restore-hosting/convert-hosting').replace('convert-dns', CompoundAction())

		# Mail and DB isn't migrated
		workflow.get_shared_action('copy-content').replace('mail', CompoundAction())
		workflow.get_shared_action('copy-content').replace('sync-mail', CompoundAction())

		# No need to verify result right now
		workflow.get_path('transfer-accounts').replace('verify-hosting', CompoundAction())

		# These actions are required but missing in base workflow
		workflow.get_shared_action('copy-web-files').insert_action(
			'copy-files-linux', CopyUnixWebContent()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'fix-unix-vhost-permissions', FixUnixVhostPermissions()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'fix-unix-vhost-structure', FixUnixVhostStructure()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'fix-permissions-old-plesks', FixUnixPermissionsOldPlesks()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'fix-permissions', FixUnixPermissions()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'fix-security-files', FixSecurityFiles()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'reset-permissions', ResetPermissions()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-wpb-sites', TransferWPBSites()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'restore-aps', RestoreApplications()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-virtual-directories', TransferVirtualDirectories()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-error-documents', TransferErrorDocuments()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-mime-types', TransferMIMETypes()
		)
