from parallels.plesk.source.expand import messages
from parallels.core.converter.business_objects.resellers import ResellersConverter
from parallels.core import target_data_model
from parallels.core.logging_context import log_context


class ExpandResellersConverter(ResellersConverter):
	@classmethod
	def _convert_source_panel_resellers(cls, source_panel_data, resellers_migration_list, report, password_holder):
		cls.logger.info(messages.DEBUG_CONVERT_EXPAND_RESELLERS)
		expand_resellers = source_panel_data
		converted_resellers = []
		for reseller in expand_resellers:
			with log_context(reseller.login):
				if resellers_migration_list is None or reseller.login in resellers_migration_list:
					reseller_report = report.subtarget(u"Reseller", reseller.login)
					if resellers_migration_list is not None:
						reseller_migration_list_plan = resellers_migration_list.get(reseller.login)
					else:
						reseller_migration_list_plan = None
					converted_reseller = cls._create_target_model_reseller(
						None, reseller, False, reseller_report, password_holder,
						None, reseller_migration_list_plan
					)
					converted_resellers.append(converted_reseller)
		return converted_resellers

	@classmethod
	def _create_target_model_reseller(
		cls, plesk_id, reseller, is_windows, reseller_report, password_holder,
		reseller_source_panel_plan, reseller_migration_list_plan
	):
		password = cls._get_reseller_password(reseller, reseller_report, password_holder)
		return target_data_model.Reseller(
			login=reseller.login,
			password=password,
			plan_name=reseller_migration_list_plan,
			clients=[],
			company='',
			personal_info=target_data_model.PersonalInfo(
				first_name=reseller.name,
				last_name='',
				email=reseller.email,
				preferred_email_format='plainText',
				address_line_1='No address',
				address_line_2='',
				city='No city',
				county='',
				state='Washington',
				postal_code='11111',
				language_code=reseller.locale[0:2],
				locale=reseller.locale,
				country_code='US',
				primary_phone='1111111',
				additional_phone='',
				fax='',
				mobile_phone=''
			),
			auxiliary_user_roles=[],
			auxiliary_users=[],
			is_enabled=reseller.is_active,
			plans={},
			source='expand',
			settings=None,
		)